<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('status', 'client_id', 'coupon_id', 'payment_method_id', 'total_price', 'delivery_cost', 'transaction_id', 'shipping_id');

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function shipping()
    {
        return $this->belongsTo('App\Models\Shipping');
    }

    public function coupon()
    {
        return $this->belongsTo('App\Models\Coupon');
    }

    public function PaymentMethod()
    {
        return $this->belongsTo('App\Models\PaymentMethod');
    }

    public function products()
    {
        return $this->belongsToMany('App\Models\Product');
    }

}